use strict;
use warnings;
use Win32::PerfLib;

my ($perf, $o, $id, $seconds);
my $threshold = 600;
my $objlist   = {};
my $system    = 2;
my $exitcode  = 0;

$perf = new Win32::PerfLib("localhost");
if(!$perf) { die "Can't open PerfLib\n"; }

if($perf->GetObjectList("$system", $objlist)) {
    my $Counters = $objlist->{Objects}->{$system}->{Counters};
    foreach $o ( keys %{$Counters}) {
        $id = $Counters->{$o}->{CounterNameTitleIndex};
        if($id == 674) {
            my $Numerator = $Counters->{$o}->{Counter};
            my $Denominator = $objlist->{Objects}->{$system}->{PerfTime};
            my $TimeBase =  $objlist->{Objects}->{$system}->{PerfFreq};
            my $counter = int(($Denominator - $Numerator) / $TimeBase );
            $seconds = $counter;
        }
    }
}

my $message = " - Uptime $seconds seconds\n";
my $status = "OK";

if ($seconds < $threshold) {
    $status = "CRITICAL";
    $exitcode = 2;
}

print $status . $message;
exit($exitcode);
