#!/usr/bin/perl -w

use strict;
use warnings;
use Win32::PerfLib;
use Win32::Process::List;

my $P = Win32::Process::List->new();
my (%proc);

my %list = $P->GetProcesses();
foreach my $key ( keys %list ) {
    $proc{$list{$key}}++;
}

my $arg ="";
my $state = "OK";
my $message = "";
my $count = 0;

while ($arg = shift @ARGV) {
    my ($process, $min, $max) = split /:/, $arg;
    $max ||= 99999;

    if (defined $proc{$process}) {
        if ($proc{$process} >= $min && $proc{$process} <= $max) {
            $message .= " - Checked '${process}'";
        } else {
            $message .= " - Process '${process}' outside margins (found:${proc{$process}}) (wanted min:${min} max:${max})";
            $state = "CRITICAL";
        }
    } else {
        $message .= " - Process '${process}' not found (wanted min:${min} max:${max})";
        $state = "CRITICAL";
    }

    $count++;
}

if ($count == 0) {
    print "WARNING - Configuration error : missing checkarray name:min [name:min:max] etc (max is optional)\n";
    exit 1;
}

if ($state eq "OK") {
    print "${state}${message}\n";
    exit 0;
} else {
    print "${state}${message}\n";
    exit 2;
}

